/************************************************************************
 *
 * \file: Testbed.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto - Demo application
 *
 * \author: Bui Le Thuan / RBVH/ENG2 / Thuan.BuiLe@vn.bosch.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef TESTBED_H_
#define TESTBED_H_

#include <glib-unix.h>
#include "libtestbedapp.h"
#include "utility/Singleton.h"
#include <session/VideoChannel.h>

enum deviceState
{
    INIT            = 0,
    CONNECTED      = 1,
    SWITCHED       = 2,
    DISCONNECTED   = 3,
};

namespace adit { namespace aauto {

class Testbed : public adit::utility::Singleton<Testbed> {
public:

    Testbed();
    virtual ~Testbed();

    void setTestbedMode(bool inTestbedMode);
    bool getTestbedMode();
    int getSurfaceID();
    int getLayerID();

    void setVideoChannel(VideoChannel* inVideoChannel);
    VideoChannel* getVideoChannel();
    void setDeviceState(deviceState inState);
    deviceState getDeviceState();
    void setCurrentAppState(int inCurrentAppState);
    int getCurrentAppState();
    void controlSurface();

    void adit_testbed_init();
    void adit_testbed_run();
    void adit_testbed_deinit();

    void adit_testbed_available();
    void adit_testbed_background();
    void adit_testbed_foreground();
    void adit_testbed_lost();

private:
    bool testbedMode;
    GMainLoop *tb_aauto_g_main_loop_ctx;
    int layerID;
    int surfaceID;

    deviceState devStat;
    int currentAppState;
    VideoChannel* videoChannel;

    static void state_changed_TB(tba_app_state_t previous_state, tba_app_state_t new_state, void *user_data);
    static bool entering_shutdown_TB(int request_id, void *user_data);
    static bool waking_up_TB(tba_app_state_t recent_active_state, tba_app_state_t *targeted_state, int request_id, void *user_data);
    static void surface_id_received_TB(unsigned int surface_id, void *user_data);
    static void surface_id_invalid_TB(unsigned int surface_id, void *user_data);
    static void log_event_TB(tba_loglevel_t level, const char *msg, void *user_data);
};

} }

#endif /* TESTBED_H_ */
